﻿Public Class VerticalStackPanel
    Inherits Panel
    Protected Overrides Function MeasureOverride(ByVal availableSize As Size) As Size
        Dim compositeSize As New Size()

        For Each child As UIElement In Children
            child.Measure(New Size(availableSize.Width, Double.PositiveInfinity))
            compositeSize.Width = Math.Max(compositeSize.Width, child.DesiredSize.Width)
            compositeSize.Height += child.DesiredSize.Height
        Next child
        Return compositeSize
    End Function


    Protected Overrides Function ArrangeOverride(ByVal finalSize As Size) As Size
        Dim x As Double = 0, y As Double = 0

        For Each child As UIElement In Children
            child.Arrange(New Rect(x, y, finalSize.Width, child.DesiredSize.Height))
            y += child.DesiredSize.Height
        Next child
        Return MyBase.ArrangeOverride(finalSize)
    End Function
End Class